/*! \file 
**********************************************************************************
*Title:                         Discretix OMA DRM v2 Toolkit Test source file
*
* Filename:                     ODRM_TLK_ATP_data.c
*
* Project, Target, subsystem:   Toolkit, OMA DRM
* 
* Created:                      06.12.2007
*
* \Author                       SagitB
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

#include "DX_VOS_BaseTypes.h"
#include "ODRM_TLK_ATP_Defines.h"

DxByte_t   TST_gKeyRingBuf[ODRMTLK_TST_MAX_SIZE_KEY_RING_BUF];
DxByte_t   TST_gDevKeyRingBuf[ODRMTLK_TST_MAX_SIZE_DEV_KEY_RING_BUF];
DxByte_t   TST_gWorkspace[ODRMTLK_TST_WORKSPACE_SIZE];
DxUint32_t TST_gNumOfSymKeys = 0;
DxUint32_t TST_gNumOfRSAKeys = 0;
DxUint32_t TST_gNumOfDHKeys  = 0;
DxUint32_t TST_gRequiredBufSizeInBytes = 0;
DxUint32_t TST_gWorkspaceSizeInBytes = 0;
DxUint8_t  TST_gPassword[ODRMTLK_TST_KEY_PASS_LENGTH_IN_BYTES]= {0x33,0x38,0xC9,0x9B,0x68};
DxUint32_t TST_gPasswordSize = ODRMTLK_TST_KEY_PASS_LENGTH_IN_BYTES;

DxUint8_t  TST_gPrivExponent[] = /*PrivetExponent_D*/
                                {0x0e,0x85,0x98,0x0c,0x64,0xed,0x94,0x26,0x69,0x65,0x35,0x7b,0x14,0x8d,0x78,0x58,
                                0x1f,0xcc,0xaf,0x34,0x9d,0xbb,0x97,0x5d,0xdb,0xd4,0x54,0xbf,0xd3,0x14,0x30,0xf7,
                                0xbc,0xad,0x1f,0x90,0x8f,0xf6,0xa4,0xad,0xec,0x59,0x63,0x6f,0xd0,0xb5,0x4b,0xc8,
                                0x14,0x61,0x41,0x84,0x7a,0x1b,0xbf,0x74,0xa7,0x83,0x82,0x12,0x6a,0x78,0x2c,0xb3,
                                0xd7,0xe3,0x72,0xfd,0x8c,0x14,0x6b,0x8d,0x0c,0xa4,0x78,0x16,0x78,0x13,0x23,0xe6,
                                0x00,0xe7,0x29,0xc5,0xc9,0xe7,0xa7,0x88,0x4d,0x9a,0x35,0x16,0xf9,0xb8,0x10,0x76,
                                0xdf,0x9b,0xbb,0x1d,0x3e,0xdf,0x80,0x67,0xf1,0x0f,0xe7,0xc7,0x2a,0x14,0x70,0x30,
                                0x09,0xd0,0x38,0xd3,0x95,0xe7,0x2f,0x37,0x76,0x78,0xc1,0xf9,0xaf,0x1a,0x81,0xa1};
DxUint16_t  TST_gPrivExponentSize = ODRMTLK_TST_RSA_1024_KEY_SIZE_IN_BYTES;
DxUint8_t   TST_gModulus[] = /* Modulus_N */
                                {0xe6,0xf1,0x8f,0xaf,0x4d,0xb6,0x24,0xa6,0x94,0x71,0xfb,0xeb,0x01,0x56,0xb6,0xdb,
                                0xca,0xdf,0xf2,0x2a,0x6c,0xb9,0x6f,0xd8,0x70,0xf2,0x8e,0x44,0x32,0xb1,0x0c,0x1b,
                                0xee,0xa8,0xdc,0x03,0x33,0x72,0xe6,0xc0,0x83,0xa7,0x47,0x34,0x01,0x10,0x1e,0xa6,
                                0x1f,0x04,0xe6,0xb3,0x41,0xec,0x97,0x59,0xf2,0xf6,0xf7,0x7c,0x16,0xc5,0xdd,0x97,
                                0xf5,0xdb,0x6c,0x60,0xbd,0x53,0xbc,0xa9,0xbd,0xd7,0xae,0xbf,0x70,0xf3,0x38,0xf4,
                                0xb4,0x5a,0x25,0x9c,0xcf,0xf1,0x2f,0xaf,0xdb,0x5d,0x43,0x5a,0xeb,0x07,0x5d,0xa7,
                                0xd8,0x44,0xa1,0x50,0x2a,0x98,0xba,0xba,0x81,0xc1,0x61,0x87,0x09,0x3b,0x54,0x8c,
                                0x20,0xde,0xc3,0x62,0x64,0xcf,0xc0,0x3f,0xe7,0x97,0xa7,0x7d,0x65,0x8e,0x31,0xeb};
DxUint16_t   TST_gModulusSize = ODRMTLK_TST_RSA_1024_KEY_SIZE_IN_BYTES;

                /*PublicExponent_E*/
DxUint8_t    TST_gPubExponent[3] = {0x01,0x00,0x01};
DxUint16_t   TST_gPubExponentSize = 3;

DxByte_t     TST_gKey[ODRMTLK_TST_AES_KEY_SIZE]        = {0xD3,0x2D,0x2A,0x70,0x4F,0x58,0x4E,0xF5,0x48,0xAE,0xA7,0x7E,
                                                         0xA7,0x9D,0x34,0x94};
DxByte_t     TST_gKeyData[ODRMTLK_TST_AES_KEY_SIZE]    = {0xE3,0x06,0x21,0x0E,0xFC,0x81,0xE3,0xB4,0x3C,0xC4,0xB4,0x64,
                                                         0xC0,0x84,0x32,0x77};
DxByte_t     TST_gPlainBuff[ODRMTLK_TST_AES_KEY_SIZE] =  {0x1B,0xDB,0x20,0xEC,0xCE,0x38,0x58,0xE6,0x36,0xE1,0xEE,0x15,
                                                         0x4A,0x11,0x04,0x93};
DxByte_t     TST_gEncryptedDataOut[ODRMTLK_TST_AES_KEY_SIZE];
DxByte_t     TST_gEncryptKeyData[ODRMTLK_TST_AES_KEY_SIZE];
DxByte_t     TST_gEncryptedPlainBuffWithK[ODRMTLK_TST_AES_KEY_SIZE] = {0xAA,0xF3,0xE0,0xDE,0x26,0xBB,0x76,0x51,0x62,0x88,
                                                                       0x05,0x09,0x8C,0x01,0xD6,0x91};
DxByte_t     TST_gKekkey[ODRMTLK_TST_AES_KEY_SIZE] =        {0xE3,0x06,0x21,0x0E,0xFC,0x81,0xE3,0xB4,0x3C,0xC4,0xB4,0x64,0xC0,
                                                             0x84,0x32,0x77};
DxByte_t     TST_gWrappedKkey[ODRMTLK_TST_WRAPPED_KEY_LENGTH_IN_BYTES] = {0x48,0x16,0x78,0xF6,0x65,0x83,0xFB,0x34,0xA1,
                                                                           0x6A,0xA3,0xF2,0x80,0x61,0x9E,0x1E,0x7E,0x39,
                                                                           0x53,0xBA,0x94,0xE7,0x70,0xB2};
CRYS_AES_IvCounter_t       TST_gIvCounter = {0};
DxByte_t     TST_gWrappedCekWithRek[ODRMTLK_TST_WRAPPED_KEY_LENGTH_IN_BYTES] = {0x2A,0x0C,0x4D,0x44,0x6F,0x4D,0xDE,0x1E,
                                                                              0x15,0x07,0xA1,0x2B,0x86,0x3C,0xA9,0x51,
                                                                              0x10,0xA2,0x2E,0x7A,0x02,0x46,0x18,0x66};

DxByte_t     TST_gKMacAndkRekBuff[ODRMTLK_TST_DOUBLE_AES_KEY_SIZE] = {0xE3,0x06,0x21,0x0E,0xFC,0x81,0xE3,0xB4,0x3C,0xC4,
                                                                      0xB4,0x64,0xC0,0x84,0x32,0x77,0x67,0xEA,0x6C,0x63,
                                                                      0xFF,0x3D,0xB5,0xCF,0xCE,0x2B,0x48,0x62,0x6A,0x25,
                                                                      0x06,0xCA};

DxByte_t    TST_gCBuff[ODRMTLK_TST_CBUFF_SIZE];
DxByte_t    TST_gHmacPlainBuffWithKmac[] = {0xFE,0xC6,0xD9,0x99,0x10,0xEB,0x7A,0x31,0xF2,0x84,0x13,0x18,0x02,0x32,
                                            0x57,0xDB, 0xCE,0xEE,0xB3,0x71};
CRYS_HASH_Result_t  TST_gHmacResultBuff;


DxByte_t   TST_gZ[Z_SIZE] = {0x1C,0xF2,0x96,0x9A,0x5E,0xDE,0xDF,0xCF,0x64,0x38,0x74,0x2B,0x8B,0x40,0x2B,0xC8,
                             0x55,0xD5,0x73,0x7F,0x91,0x2D,0xC9,0xC7,0x67,0xE3,0x4A,0x98,0xA1,0x59,0x23,0xBA,
                             0x24,0x0C,0xB1,0x98,0x07,0x6C,0xEE,0x50,0x85,0xDE,0x56,0xCC,0x30,0xB1,0xF0,0x37,
                             0x13,0xD0,0x8F,0xC4,0x19,0x72,0xA6,0xEF,0x29,0xCF,0x33,0x7B,0x93,0x46,0x2D,0x0B,
                             0x15,0xB9,0x06,0x7E,0x8F,0x92,0xC0,0xE9,0xE7,0x22,0xFA,0xB2,0xD6,0xFC,0x96,0xB6,
                             0xF2,0x13,0x84,0xD1,0xCA,0x5F,0xA1,0xB2,0x66,0xC2,0x6F,0x38,0x39,0x73,0xBD,0x3F,
                             0xB0,0x4B,0xB7,0x77,0xAA,0x72,0xA8,0x81,0x10,0xA6,0xDD,0xF6,0x78,0xF3,0x18,0x2C,
                             0x38,0x7C,0x88,0x80,0xC1,0x5C,0x40,0xB6,0x18,0x53,0x17,0xCD,0x23,0x87,0xAF,0x73};

DxByte_t   TST_gC1[ODRMTLK_TST_RSA_1024_KEY_SIZE_IN_BYTES];

CRYS_RSAUserPrivKey_t       TST_gRiPrivKey;
CRYS_RSAUserPubKey_t        TST_giPubKey;
CRYS_RSAKGData_t            TST_gKeyGenData; 
CRYS_RSAPrimeData_t         TST_gPrimeData;
DxByte_t                    TST_gKMacAndkMekBuff[ODRMTLK_TST_DOUBLE_AES_KEY_SIZE];
DxByte_t                    TST_gC[ODRMTLK_TST_C_SIZE];
DxByte_t                    TST_gC1Buff[ODRMTLK_TST_RSA_1024_KEY_SIZE_IN_BYTES]; 
DxByte_t                    TST_gC2Buff[ODRMTLK_TST_C2_SIZE ];
DxByte_t                    TST_gZBuff[ODRMTLK_TST_RSA_1024_KEY_SIZE_IN_BYTES];






